// File: dlas.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 14 Nov, 2003

#ifndef _D_LAS_BASE_H
#define _D_LAS_BASE_H


#include "dsvd.h"

namespace mysvd {
  class dlas : public dsvd {
  private:
    void init_error_messages();
  protected:
    void setupDefault();
    void   machar(long *, long *, long *, long *, long *);
  
    long   check_parameters(long, long, long, double, double, long, long);

    void   write_data(FILE*, long, long, double, double, bool, double,
                      long, long, long);
  public:
    dlas() : dsvd() { xv1 = xv2 = a = NULL; init_error_messages(); }
    dlas(long nm, long nz, long sd) : dsvd(nm, nz, sd)
    { 
      xv1 = xv2 = a = NULL;
      init_error_messages();
    }

    // The actual svd computation functions remain undefined, see dlas1.h, dlas2.h
  };

}

#endif // _D_LAS_BASE_H
