/* File: blas.h -*- c++ -*-
 * Author: Suvrit Sra
 * has the common blas routines used by svdpack
 * Time-stamp: <29 November 2007 04:36:07  CET --  suvrit>
 */

/*  In the ATLAS Style cblas interface standard */

/* ======================================================== */
/* DOUBLE PRECISION BLAS */

#ifndef _CBLAS_H_
#define _CBLAS_H_

double  cblas_dasum  (long, double *, long                       );  
void    cblas_datx   (long, double, double *,long, double *, long);
void    cblas_daxpy  (long, double, double *,long, double *, long);

void    cblas_dcopy  (long n,double *dx,long incx,double *dy,
                long incy                                  );
double  cblas_ddot   (long, double *,long, double *, long        );

void    cblas_dgemm  (long, long, long, long, long, double, 
                double **, double *, double, double *      );
void    cblas_dgemm2 (long, long, long, long, long, double, 
                double **, double **, double, double **    );
void    cblas_dgemm3 (long, long, long, long, long, double,
                double **, long, long, double **, long,
                long, double, double **, long, long        );

void    cblas_dgemv  (long, long, long, double, double **,
                double *, double, double *                 );
void    cblas_dgemv2 (long, long, long, double, double **, long,
                long, double *, double, double *           );

double  cblas_dmax   (double, double                             );
double  cblas_dmin   (double, double                             );

void    cblas_drot   (long, double *, double *, double, double   );
void    cblas_drotg  (double *, double *, double *, double *     );

void    cblas_dscal  (long, double, double *,long                );
void    cblas_dsbmv  (long, long, double, double **, 
                double *, double, double *                 );
void    cblas_dsort2 (long,long, double *, double *              );
void    cblas_dswap  (long, double *, long, double *, long       );
void    cblas_dtbmv  (long, long, long, double **, double *      );

/* ======================================================== */
/* SINGLE PRECISION BLAS */

float   cblas_sasum  (long, float *, long                       );  
void    cblas_satx   (long, float, float *,long, float *, long);
void    cblas_saxpy  (long, float, float *,long, float *, long);

void    cblas_scopy  (long n,float *dx,long incx,float *dy,
                long incy                                  );
float   cblas_sdot   (long, float *,long, float *, long        );

void    cblas_sgemm  (long, long, long, long, long, float, 
                float **, float *, float, float *      );
void    cblas_sgemm2 (long, long, long, long, long, float, 
                float **, float **, float, float **    );
void    cblas_sgemm3 (long, long, long, long, long, float,
                float **, long, long, float **, long,
                long, float, float **, long, long        );

void    cblas_sgemv  (long, long, long, float, float **,
                float *, float, float *                 );
void    cblas_sgemv2 (long, long, long, float, float **, long,
                long, float *, float, float *           );

float  cblas_smax   (float, float                             );
float  cblas_smin   (float, float                             );

void    cblas_srot   (long, float *, float *, float, float   );
void    cblas_srotg  (float *, float *, float *, float *     );

void    cblas_sscal  (long, float, float *,long                );
void    cblas_ssbmv  (long, long, float, float **, 
                float *, float, float *                 );
void    cblas_ssort2 (long,long, float *, float *              );
void    cblas_sswap  (long, float *, long, float *, long       );
void    cblas_stbmv  (long, long, long, float **, float *      );


#endif // _CBLAS_H_
