#ifndef _CBLAS_H_
#define _CBLAS_H_

#define ZERO 0.0
#define ONE 1.0
#define TRANSP   1
#define NTRANSP  0

void cblas_dgemv(long transa, long m, long n, 
                 double alpha, double **a, double *x, double beta, double *y);

void cblas_dgemm(long transa, long transb, long m, long n, long k, 
                 double alpha, double **a, double *b, double beta, double *c);


void cblas_dtbmv(long trans, long n, long k, double **a, double *x);

void cblas_dswap(long n,double *dx,long incx,double *dy,long incy);

void cblas_drot(long n, double *dx, double *dy, double c, double s);

void cblas_drotg(double *da, double *db, double *c, double *s);

double cblas_ddot(long n,double *dx,long incx,double *dy,long incy);

void cblas_dscal(long n,double da,double *dx,long incx);

void cblas_daxpy (long n,double da,double *dx,long incx,double *dy,long incy);

void cblas_dcopy(long n,double *dx,long incx,double *dy,long incy);

void cblas_dgemm2(long transa, long transb, long m, long n, long k, 
                  double alpha, double **a, double **b, double beta, double **c);

void cblas_dsbmv(long n, long k, double alpha, double **a, 
                 double *x, double beta, double *y);

void cblas_datx(long n,double da,double *dx,long incx,double *dy,long incy);

void cblas_dgemm3(long transa, long transb, long m, long n, long k, 
                  double alpha, double **a, long ira, long ica, double **b,
                  long irb, long icb, double beta, double **c, long irc,
                  long icc);

double cblas_dasum(long n, double *dx, long incx);

void cblas_dgemv2(long transa, long m, long n, 
                  double alpha, double **a, long ira, long ica,
                  double *x, double beta, double *y);


double fsign(double a,double b);
double dmax(double a, double b);
double dmin(double a, double b);
long imin(long a, long b);
long imax(long a,long b);


void cblas_sgemv(long transa, long m, long n, 
                 float alpha, float **a, float *x, float beta, float *y);

void cblas_sgemm(long transa, long transb, long m, long n, long k, 
                 float alpha, float **a, float *b, float beta, float *c);


void cblas_stbmv(long trans, long n, long k, float **a, float *x);

void cblas_sswap(long n,float *dx,long incx,float *dy,long incy);

void cblas_srot(long n, float *dx, float *dy, float c, float s);

void cblas_srotg(float *da, float *db, float *c, float *s);

float cblas_sdot(long n,float *dx,long incx,float *dy,long incy);

void cblas_sscal(long n,float da,float *dx,long incx);

void cblas_saxpy (long n,float da,float *dx,long incx,float *dy,long incy);

void cblas_scopy(long n,float *dx,long incx,float *dy,long incy);

void cblas_sgemm2(long transa, long transb, long m, long n, long k, 
                  float alpha, float **a, float **b, float beta, float **c);

void cblas_ssbmv(long n, long k, float alpha, float **a, 
                 float *x, float beta, float *y);

void cblas_satx(long n,float da,float *dx,long incx,float *dy,long incy);

void cblas_sgemm3(long transa, long transb, long m, long n, long k, 
                  float alpha, float **a, long ira, long ica, float **b,
                  long irb, long icb, float beta, float **c, long irc,
                  long icc);

float cblas_sasum(long n, float *dx, long incx);

void cblas_sgemv2(long transa, long m, long n, 
                  float alpha, float **a, long ira, long ica,
                  float *x, float beta, float *y);


float sfsign(float a,float b);
float smax(float a, float b);
float smin(float a, float b);

#endif // _CBLAS_H_
