// randDmatrix -- generate an n x n dissimilarity matrix
// Copyright (C) 2004 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include <gsl/gsl_matrix.h>
#include "util.h"
#include <iostream>

using namespace std;

int main(int argc, char** argv) 
{

  if (argc != 2) {
    cerr << "randm: n\n";
    return -1;
  }

  int n = atoi(argv[1]);

  if (n <= 0) {
    cerr << "Invalid matrix size requested\n";
    return -1;
  }

  gsl_matrix* A = random_matrix(n, n);
  gsl_matrix* B = gsl_matrix_alloc(n, n);

  gsl_matrix_transpose_memcpy(B, A);

  // Now A is symmetric
  gsl_matrix_add(A, B);

  gsl_matrix_scale(A, 20);
  // Remove the diagonal
  for (unsigned int i = 0; i < A->size1; i++)
    gsl_matrix_set(A, i, i, 0);

  return   printon(A, cout);
}
