// File: metricL2.cc
// Author: Suvrit Sra
// (c) 2004, Suvrit Sra
// Impl. of l2 metric nearness

#include "metricL2.h"

/**
 * Perform fast L2 metric nearness
 *
 */
int MetricL2::execute()
{
    std::cout << "MetricL2::execute() Entered\n";

   
    uint N = d->size1;
    uint r = N*(N-1)*(N-2)/2;

    // Allocate z
    alloc_dual_variables();
    double zsum = 10;
    uint iter    = 1;
    if (maxiter == 0)
        maxiter = 5*N;

    // Record time here
    clock_t elapse = clock();
    
    uint t;                     // Current triangle

    while (zsum > tol && iter < maxiter) {
        //std::cout << "Outer iteration: " << iter
        //        << ", zsum = " << zsum << std::endl;

        zsum = 0.0;

        // t index the current triangle ...
        t = 0;

        // Go thru all the triangles in the foll. order
        // Perhaps better to go thru triangles in some random order.
        // 012, 120, 201, 013, 130, 301,...
        // The following order seems very bad. Perhaps a FW type ordering.
        for (uint i = 0; i < N; i++) {
            for (uint j = i+1; j < N; j++) {
                for (uint k = j+1; k < N; k++) {
                    fixOneTriangle(i, j, k, z[t], zsum);
                    ++t;
                    fixOneTriangle(j, k, i, z[t], zsum);
                    ++t;
                    fixOneTriangle(k, i, j, z[t], zsum);
                    ++t;
                }
            }
        }
        ++iter;
    }

    elapse = clock() - elapse;
    unsigned long int flops = iter * r * 20;
    double ns = elapse * 1.0 / CLOCKS_PER_SEC;

    double obj = compute_obj();

    // double relerror = sqrt(obj) / fnorm(D);

    std::cout << "MetricL2::execute(): Elapsed time = " 
              << ns   << " secs, "
              << "Iterations:= " << iter
              << ", zsum:= " << zsum << "\n";
    std::cout << "Objective value = " << obj 
              << ", FLOPS = " << flops << std::endl;
        //<< ", RelError = " << relerror << "\n";
    std::cout << "SUMMARY:" 
              << N << " " << ns 
              << " " << obj << std::endl;
    return 0;
}

inline double MetricL2::fixOneTriangle(uint i, uint j, uint k, 
                                       double& err, double& zsum) 
{
    double ab, bc, ca;
    double oab, alpha = 0.0;
    double del;

    ab = gsl_matrix_get( d, i, j );
    bc = gsl_matrix_get( d, j, k );
    ca = gsl_matrix_get( d, i, k );
                    

    // Save leading edge for abc
    oab = ab;   
    
    alpha = err;
    del = ab - bc - ca + 3*alpha;
    
    if (del < 0) {
      ab = ab + alpha;
      bc = bc - alpha;
      ca = ca - alpha;
    // Do orthogonal projection, basically what we are doing here is
    // x' == x - 1 / ||a||^2 [ <a, x> - b ]^+, the '+' means max(0, <a.x>-b)
    // so we take action only if del > 0
    //if (del > 0) { -- THIS WAS THE BUG
    } else {
      del = del / 3;
      ab  = ab + alpha - del;
      bc  = bc + del - alpha;
      ca  = ca + del - alpha;
    }
    
    gsl_matrix_set(d, i, j, ab);
    gsl_matrix_set(d, j, k, bc);
    gsl_matrix_set(d, i, k, ca);
    
    // Symmetrize (useless operation, doubles the time
    // We should try to get rid of it....
    gsl_matrix_set(d, j, i, ab);
    gsl_matrix_set(d, k, j, bc);
    gsl_matrix_set(d, k, i, ca);
    
      
    //err = 2*(oab - ab) + err;
    err = oab - ab + err;
    zsum += fabs(ab - oab);
    return zsum;
}

inline double MetricL2::compute_obj ()
{
    double obj = 0;
    for (uint i = 0; i < d->size1*d->size2; i++) {
      double tmp = d->data[i] - D->data[i];
      obj += (tmp * tmp);
    }
    return 0.25*obj;
}
