// File: metric.h -*- c++ -*-
// Author: Suvrit Sra
// Header for the metric nearness problem.


#ifndef _METRIC_H_
#define _METRIC_H_

#include <iostream>
#include <time.h>
#include <cmath>
#include <cstring>
#include "util.h"


class Metric {
  // This is needed, else compiler refuses to compile!
  typedef gsl_matrix* matrix;
protected:
  double* e;               // error vector
  matrix d;                // The input diss. matrix
  matrix D;                // Copy of 'd'
  double* z;               // Dual vars corr. to triangles.
  
  uint maxiter;
  double tol;

  int alloc_dual_variables();
public:
  virtual double compute_obj() = 0;
  virtual int    execute()     = 0;

  matrix    get_matrix() { 
    return d;
  }
  matrix    get_copy()   {
    return D;
  }

  void make_copy() {
    D = gsl_matrix_alloc ( d->size1, d->size2);
    gsl_matrix_memcpy ( D, d );
  }

  void set_matrix(matrix d) { this->d = d;}
  void set_maxiter(uint m) { maxiter = m;}
  void set_tol(double t) { tol = t;}

  void vecadd  ( double* x, double* y, uint N)
  {
    for (uint i = 0; i < N; i++)
      x[i] += y[i];
  }

  void vecscale( double* x, double s,  uint N)
  {
    for (uint i = 0; i < N; i++)
      x[i] *= s;
  }

  void vecmin  ( double* x, double* y, uint N)
  {
    for (uint i = 0; i < N; i++)
      x[i] = std::min(x[i], y[i]);
  }

  void vecsub  ( double* x, double* y, uint N)
  {
    for (uint i = 0; i < N; i++)
      x[i] -= y[i];
  }

  // Function depends on i < j
  double vecget( double* v, uint i, uint j, uint n)
  {
    uint t = i*(n-1) - (i+1)*i/2 + j;
    --t;
    return v[t];
  }

  // Function depends on i < j
 void vecset( double* v, uint i, uint j, double val, uint n)
  {
    uint t = i*(n-1) - (i+1)*i/2 + j;
    --t;
    v[t] = val;
  }

};

#endif
