// (c) 2004, Suvrit Sra
#include "metric.h"
#include <cstring>


/**
 * Allocates memory for the dual variables.
 */
int Metric::alloc_dual_variables()
{
   uint N = d->size1;
   uint r = N*(N-1)*(N-2)/2;
   double MB = (r * sizeof(double)) / (1024.0*1024.0);
   try {
     std::cerr << "Metric::alloc() Trying to alloc " << MB << " MB\n";
     z = new double [r];
   } catch (std::exception& e) {
     std::cerr << "Exception: " << e.what() << std::endl;
     if (z == 0) {
       std::cerr << "Metric::alloc(): Out of memory!\n";
     }
     return -2;
   }
   memset (z, 0, r * sizeof(double));
   return 0;
}

