#!/lusr/bin/perl -w


# File: genmtx.pl
# Author: Suvrit Sra
# Creates random diss. matrices for experimentation

use strict;
use Getopt::Long;
use POSIX;
use IO;


my $version = "0.1";
my $showhelp;
my $showver;
my $lower;
my $upper;
my $outpre;

GetOptions('--version', \$showver,
           '--help', \$showhelp,
           '-l=i', \$lower,
           '--out=s',\$outpre,
           '-u=i', \$upper);


version() if $showver;
showHelp() if $showhelp;
showHelp() unless ($lower and $upper);
$outpre = "matrix" unless $outpre;

if ($lower > $upper) {
  print STDERR "genmtx.pl: Lower limit cannot exceed upper limit\n";
  exit(2);
}

for (my $i = $lower; $i <= $upper; $i++) {
  system("./randDmatrix $i > $outpre.$i");
}

# SUB: version
# print version info for this script.
sub version {
  print <<HERE;
genmtx.pl: Version $version Author: Suvrit Sra (suvrit\@cs.utexas.edu)
HERE
  exit(0);
}

# SUB: showHelp
# Shows usage info for this script
sub showHelp {
  print <<HERE;
Generates random matrices in GSL format.
Usage: genmtx.pl -l=<lower> -u=<upper> [--out=<prefix>] [--version] [--help]

       -l=<lower>     Starts with a random <lower> x <lower> matrix.
       -u=<upper>     End at a random <upper> x <upper> matrix.
       --out=<prefix> The matrices are left in files <prefix>.<lower> ...
       --help         This help message
       --version      Print version info for this script.
HERE
  exit(1);
}
