#!/lusr/bin/perl -w

# File: gencplex.pl
# Author: Suvrit Sra
# Time-stamp: <07 December 2004 11:44:00 AM CST --  suvrit>

# Generates both the .lp file and the command script file for cplex.


use strict;
use Getopt::Long;
use POSIX;
use IO;


my $version = "0.1";
my $showhelp;
my $showver;
my $lower;
my $upper;
my $ptype;

GetOptions('--version', \$showver,
           '--help', \$showhelp,
           '-l=i', \$lower,
           '--type=i', \$ptype,
           '--out=s',\$outpre,
           '-u=i', \$upper);

version() if $showver;
showHelp() if $showhelp;
showHelp() unless ($lower and $upper);
$outpre = "matrix" unless $outpre;
$ptype = 2 unless $ptype;

if ($lower > $upper) {
  print STDERR "gencplex.pl: Lower limit cannot exceed upper limit\n";
  exit(2);
}

for (my $i = $lower; $i <= $upper; $i++) {
  system("./mkcplex $ptype $outpre.$i");
}

# SUB: version
# print version info for this script.
sub version {
  print <<HERE;
gencplex.pl: Version $version Author: Suvrit Sra (suvrit\@cs.utexas.edu)
HERE
  exit(0);
}

# SUB: showHelp
# Shows usage info for this script
sub showHelp {
  print <<HERE;
Generates random matrices in GSL format.
Usage: gencplex.pl -l=<lower> -u=<upper> [--out=<prefix>] [--version] [--help]

       -l=<lower>     Starts with a random <lower> x <lower> matrix.
       -u=<upper>     End at a random <upper> x <upper> matrix.
       --out=<prefix> The LPs/QPs are left in files <prefix>.<lower> ...
       --type=<1|2>   Type 1 == gen. LP and type 2 = gen QP
       --help         This help message
       --version      Print version info for this script.
HERE
  exit(1);
}

