/**        -*- c++ -*-
 * File: driver.h
 * Author: Suvrit Sra
 * Header file for driver portion of metric nearness software
 */

#include <cstdio>
#include <unistd.h>
#include <getopt.h>
#include "util.h"

class Driver {
private:
  int    argc;
  char **argv;
  

  static const option long_opts[9];
  
  const char* opt_string;
  char* progname;
  
  char* outfile;
  bool output_matrix;
  char* version;
  char file[512];
  uint maxiter;                 // Max. outer iterations or cycles
  double tol;                   // Convergence tolerance
  double scale;
  int algo;

  FILE* fp;
  void showHelp();
  int  processOptions();
  void printInfo();

public:
  Driver (int argc, char** argv) {
    this->argc = argc;
    this->argv = argv;
    
    version = "Metric nearness v-1.0 (c) Suvrit Sra\n";
    progname = argv[0];
    
    opt_string = "f:a:m:t:hvs:o";
    maxiter = 0;
    tol     = 1e-3;
    scale   = 1.0;
    output_matrix = false;
    outfile = 0;
    fp = stdout;
  }
  int execute();
};
