function As=sqrtm_fast(A)
%
% function sqrtm_fast
%
% Calculating matrix square root using schur decomposition
%
%  ToDO:For Hermitian positive definite there is a faster version based on
%      Chapter 6 of "Functions of Matrices" by N. J. Higham
%
[U,T]=schur(A,'complex');
if isequal(T,diag(diag(T)))     
    Ts = diag(sqrt(diag(T)));   
else
    Ts = sqrtm_triu(T);
end
As = U * Ts * U';
