%
% Most part of installation routines is copied from installation file
% of lightspeed by Tom Minka
%
cd('Thirdparty/lightspeed')

fprintf('Compiling lightspeed mex files...\n');

% Matlab version
v = sscanf(version,'%d.%d.%*s (R%d) %*s');
% v(3) is the R number
% could also use v(3)>=13
atleast65 = (v(1)>6 || (v(1)==6 && v(2)>=5));
atleast75 = (v(1)>7 || (v(1)==7 && v(2)>=5));
atleast76 = (v(1)>7 || (v(1)==7 && v(2)>=6));
atleast78 = (v(1)>7 || (v(1)==7 && v(2)>=8));

% these are done first to initialize mex
mex -c util.c
libdir = '';
if ispc
  if strcmp(mexcompiler,'cl')
    libdir = fullfile(matlabroot,'extern\lib\win32\microsoft');
  else
    libdir = fullfile(matlabroot,'extern\lib\win32\lcc');
  end
end

% Routines that use LAPACK
lapacklib = '';
blaslib = '';
flags = '';
lapackflags = flags;
if atleast78
    lapackflags = [lapackflags ' -DBLAS64'];
end
if ispc
    if strncmp(compiler,'MSVC',4)
        if atleast65
            % version >= 6.5
            lapacklib = fullfile(libdir,'libmwlapack.lib');
        end
    else
        lapacklib = fullfile(libdir,'libmwlapack.lib');
    end
    if atleast75
        blaslib = fullfile(libdir,'libmwblas.lib');
    end
    %%% Paste the location of libmwlapack.lib %%%
    %lapacklib = '';
    if ~exist(lapacklib,'file')
        lapacklib = 'dtrsm.c';
        fprintf('libmwlapack.lib was not found.  To get additional optimizations, paste its location into install_lightspeed.m\n');
    else
        fprintf('Using the lapack library at %s\n',lapacklib);
    end
else
    % in version 7.5, non-PC systems do not need to specify lapacklib,
    % but they must use an underscore when calling lapack routines
    % http://www.mathworks.com/help/techdoc/matlab_external/br_2m24-1.html
    lapackflags = [lapackflags ' -DUNDERSCORE_LAPACK_CALL'];
    if atleast76
        lapacklib = '-lmwlapack';
        blaslib = '-lmwblas';
    end
end
disp(['mex' lapackflags ' solve_triu.c "' lapacklib '" "' blaslib '"'])
eval(['mex' lapackflags ' solve_triu.c "' lapacklib '" "' blaslib '"']);

if ispc
    if strcmp(mexcompiler,'cl')
        system('install_random.bat');
        mex randgamma.c util.obj random.lib
    else
        fprintf('mexcompiler is not cl. The randomseed() function will have no effect.');
        mex randgamma.c util.obj random.c
    end
else
  %system('cc -fPIC -O -c random.c; cc -shared -Wl,-E -Wl,-soname,`pwd`/librandom.so -o librandom.so random.o')
    % I changed librandom.so to random.o
    mex randgamma.c util.o random.o -lm
end

cd('../../manifoldPSD');
mex sqrtm_triu.c
cd('../eg');
mex elsd.c
cd('..');
addpath(genpath(pwd))
fprintf('Done.\n');